/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.util.ProgressListener;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressIndicator
extends JPanel
implements ProgressListener {
    JLabel lMessage;
    JLabel lPercent;
    JProgressBar jProgressBar;
    private int fOnePercent = 1;
    protected Container fParent;
    protected JDialog fDialog;
    protected String fTitle = "";
    private int fSubsetLimit;
    private int fStepWidth;
    private int fAccumulator;

    public ProgressIndicator(Container parent) {
        this.fParent = parent;
        this.initComponents();
    }

    public ProgressIndicator(Container parent, String title) {
        this(parent);
        this.fTitle = title;
    }

    public ProgressIndicator(Container parent, String title, String message) {
        this(parent, title);
        this.lMessage.setText(message);
    }

    public ProgressIndicator(Container parent, String title, String message, int min, int max) {
        this(parent, title, message);
        this.jProgressBar.setMinimum(min);
        this.jProgressBar.setMaximum(max);
    }

    private void initComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setVisible(false);
        this.setSize(500, 100);
        this.lMessage = new JLabel();
        this.lMessage.setText(" ");
        this.lMessage.setHorizontalAlignment(0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 5.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        ((GridBagLayout)this.getLayout()).setConstraints(this.lMessage, gbc);
        this.add(this.lMessage);
        this.jProgressBar = new JProgressBar();
        this.jProgressBar.setValue(0);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 10, 0, 10);
        ((GridBagLayout)this.getLayout()).setConstraints(this.jProgressBar, gbc);
        this.add(this.jProgressBar);
        this.lPercent = new JLabel();
        this.lPercent.setHorizontalAlignment(0);
        this.lPercent.setText("0%");
        this.lPercent.setBounds(0, 103, 500, 34);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 2, 0);
        ((GridBagLayout)this.getLayout()).setConstraints(this.lPercent, gbc);
        this.add(this.lPercent);
    }

    public String getNote() {
        return this.lMessage.getText();
    }

    public int getMinimum() {
        return this.jProgressBar.getMinimum();
    }

    public int getValue() {
        return this.jProgressBar.getValue();
    }

    public void setMaximum(int max) {
        this.jProgressBar.setMaximum(max);
        this.fOnePercent = Math.max((max - this.jProgressBar.getMinimum()) / 100, 1);
    }

    public void setNote(String message) {
        this.lMessage.setText(message);
    }

    public void setMinimum(int min) {
        this.jProgressBar.setMinimum(min);
        this.fOnePercent = Math.max((this.jProgressBar.getMaximum() - min) / 100, 1);
    }

    public void setValue(int value) {
        this.fAccumulator += value;
        if (this.fAccumulator >= this.jProgressBar.getValue() + this.fOnePercent) {
            if (!this.jProgressBar.isShowing()) {
                this.jProgressBar.setVisible(true);
            }
            this.jProgressBar.setValue(value);
            int percent = (int)(100.0f / (float)(this.jProgressBar.getMaximum() - this.jProgressBar.getMinimum()) * (float)value);
            percent = Math.min(percent, 100);
            this.lPercent.setText(percent + "%");
            this.forcePainting();
            this.fAccumulator = 0;
        }
    }

    public void setSubset(int maxPercent, int nrOfIncrements) {
        this.fSubsetLimit = this.jProgressBar.getMaximum() * maxPercent / 100;
        this.fStepWidth = (this.fSubsetLimit - this.jProgressBar.getMinimum()) / nrOfIncrements;
    }

    public void increment(int steps) {
        this.setValue(this.jProgressBar.getValue() + steps * this.fStepWidth);
    }

    public void fillRest() {
        if (this.fSubsetLimit > 0 && this.jProgressBar.getValue() < this.fSubsetLimit) {
            this.setValue(this.fSubsetLimit);
        } else {
            this.setValue(this.jProgressBar.getMaximum());
        }
    }

    private void forcePainting() {
        if (this.fDialog != null) {
            Graphics g = this.getGraphics();
            this.paint(g);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.fParent != null) {
                this.getDialog();
                this.fDialog.setVisible(true);
                this.forcePainting();
            } else {
                this.setVisible(true);
            }
        } else {
            super.setVisible(false);
        }
    }

    public void dispose() {
        if (this.fDialog != null) {
            this.fDialog.setVisible(false);
            this.fDialog.dispose();
        } else {
            this.setVisible(false);
        }
    }

    protected JDialog getDialog() {
        if (this.fDialog == null) {
            if (this.fParent instanceof JDialog) {
                this.fDialog = new JDialog((JDialog)this.fParent, this.fTitle, false);
            } else if (this.fParent instanceof JFrame) {
                this.fDialog = new JDialog((Frame)((JFrame)this.fParent), this.fTitle);
            } else {
                System.out.println("ProgressIndicator: parent sollte JDialog oder JFrame sein");
                this.fDialog = new JDialog();
            }
            this.fDialog.setContentPane(this);
            this.fDialog.setSize(400, 100);
            if (this.fParent != null) {
                Rectangle bounds = this.fParent.getBounds();
                Rectangle abounds = this.fDialog.getBounds();
                this.fDialog.setLocation(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
            }
        }
        return this.fDialog;
    }

    public String getTitle() {
        return this.fTitle;
    }

    public void setTitle(String title) {
        this.fTitle = title;
    }
}

